<?php


/**
 *
 */
class Peserta extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->helper('form');
    $this->load->library('form_validation');
    $this->load->library('upload');
    $this->load->helper('url_helper');
    $this->load->helper('text');
    $this->load->helper('date');
    $this->load->library('pagination');
    $this->load->model('Admin_model');
  }

  public function index(){

		if($this->session->userdata('status') != "login"){
			redirect(base_url('admin/login'));
		}

		$query = "SELECT A.*,B.jenis,B.harga,C.nama FROM peserta A INNER JOIN jadwal B ON A.jadwal_id=B.id INNER JOIN tb_admin C ON A.username=C.username ORDER BY A.created_at DESC";

    $data['peserta'] = $this->db->query($query)->result();

    $this->load->view('pages/admin/header');
		$this->load->view('pages/admin/daftar_peserta',$data);
		$this->load->view('pages/admin/footer');
	}

  public function cetak($id){

		if($this->session->userdata('status') != "login"){
			redirect(base_url('admin/login'));
		}

		$query = "SELECT A.*,B.jenis,B.harga,C.nama FROM peserta A INNER JOIN jadwal B ON A.jadwal_id=B.id INNER JOIN tb_admin C ON A.username=C.username WHERE A.id=$id ORDER BY A.created_at DESC";

    $data['peserta'] = $this->db->query($query)->row();

    $this->load->view('pages/admin/cetakpeserta.php',$data);
	}

	public function print(){

		if($this->session->userdata('status') != "login"){
			redirect(base_url('admin/login'));
		}

		$query = "SELECT A.*,B.jenis,B.harga,C.nama FROM peserta A INNER JOIN jadwal B ON A.jadwal_id=B.id INNER JOIN tb_admin C ON A.username=C.username ORDER BY A.created_at DESC";

    $data['peserta'] = $this->db->query($query)->result();

    $this->load->view('pages/admin/cetakpesertasemua.php',$data);
	}

  public function proses_tambah(){

    if($this->session->userdata('status') != "login"){
			redirect(base_url('admin/login'));
		}

		$data = $this->input->post();

		$this->db->insert('jadwal',$data);
    redirect(base_url('admin/jadwal'));

  }

  public function edit(){

    if($this->session->userdata('status') != "login"){
			redirect(base_url('admin/login'));
		}

		$id = $this->uri->segment(4);

    $where = array('id' => $id, );

		$data['jadwal'] = $this->db->get_where('jadwal',$where)->result();

		$this->load->view('pages/admin/header');
		$this->load->view('pages/admin/edit_jadwal',$data);
		$this->load->view('pages/admin/footer');
	}

  public function proses_edit(){

    if($this->session->userdata('status') != "login"){
			redirect(base_url('admin/login'));
		}

    $id = $this->input->post('id');

		$data = $this->input->post();

		unset($data['id']);

		$this->db->where('id',$id);
		$this->db->update('jadwal',$data);

    redirect(base_url('admin/jadwal'));
  }

  public function hapus(){

    if($this->session->userdata('status') != "login"){
			redirect(base_url('admin/login'));
		}

		$id_rule = $this->uri->segment(4);

		$this->db->where('id',$id);
    $this->db->delete('jadwal');

		redirect(base_url('admin/jadwal'));
	}

}
