const cards = document.querySelectorAll('.card');

const observer = new IntersectionObserver(entries => {
  entries.forEach(entry => {
    if (entry.isIntersecting) {
      entry.target.style.opacity = 1;
      entry.target.style.transform = 'translateY(0)';
    }
  });
}, { threshold: 0.2 });

cards.forEach(card => {
  card.style.opacity = 0;
  card.style.transform = 'translateY(40px)';
  observer.observe(card);
});

document.addEventListener("DOMContentLoaded", () => {

  // Fade-in card animation
  const cards = document.querySelectorAll('.card');
  const observer = new IntersectionObserver(entries => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        entry.target.style.opacity = 1;
        entry.target.style.transform = 'translateY(0)';
      }
    });
  }, { threshold: 0.2 });

  cards.forEach(card => {
    card.style.opacity = 0;
    card.style.transform = 'translateY(40px)';
    observer.observe(card);
  });

  // Slider logic (FIXED)
  document.querySelectorAll(".slider").forEach(slider => {
    const slides = slider.querySelector(".slides");
    const slideItems = slider.querySelectorAll(".slide");
    const prev = slider.querySelector(".prev");
    const next = slider.querySelector(".next");

    let index = 0;
    const total = slideItems.length;

    if (total <= 1) {
      slider.classList.add("single");
      return;
    }

    function update() {
      slides.style.transform = `translateX(-${index * 100}%)`;
    }

    prev.addEventListener("click", e => {
      e.stopPropagation();
      index = (index - 1 + total) % total;
      update();
    });

    next.addEventListener("click", e => {
      e.stopPropagation();
      index = (index + 1) % total;
      update();
    });

    // 👉 Swipe support (BENAR)
    let startX = 0;

    slides.addEventListener("touchstart", e => {
      startX = e.touches[0].clientX;
    });

    slides.addEventListener("touchend", e => {
      const endX = e.changedTouches[0].clientX;
      if (startX - endX > 50) next.click();
      if (endX - startX > 50) prev.click();
    });
  });

});