const container = document.getElementById("hearts-container");

const heartImages = [
    "/static/media/hearts/heart1.png",
    "/static/media/hearts/heart2.png",
    "/static/media/hearts/heart3.png",
    "/static/media/hearts/heart4.png"
];

function createHeart() {
    const heart = document.createElement("div");
    heart.className = "falling-heart";

    const img = heartImages[Math.floor(Math.random() * heartImages.length)];
    heart.style.backgroundImage = `url(${img})`;

    const size = Math.random() * 14 + 16;
    heart.style.width = size + "px";
    heart.style.height = size + "px";

    heart.style.left = Math.random() * 100 + "vw";

    const duration = Math.random() * 4 + 6;
    heart.style.animationDuration = duration + "s";

    container.appendChild(heart);

    setTimeout(() => {
        heart.remove();
    }, duration * 1000);
}

/* ❤️ jatuh otomatis */
setInterval(createHeart, 700);

/* 🎁 gift burst saat klik layar */
document.addEventListener("click", () => {
    for (let i = 0; i < 8; i++) {
        setTimeout(createHeart, i * 80);
    }
});
