from flask import Flask, render_template, request, redirect, session
from config import SECRET_PASSWORD

app = Flask(__name__)
app.secret_key = "super-secret-love-key"

@app.route("/", methods=["GET", "POST"])
def password():
    if request.method == "POST":
        if request.form["password"] == SECRET_PASSWORD:
            session["access"] = True
            return redirect("/intro")
    return render_template("password.html")

@app.route("/intro")
def intro():
    if not session.get("access"):
        return redirect("/")
    return render_template("intro.html")

@app.route("/story")
def story():
    if not session.get("access"):
        return redirect("/")

    timeline = [
        {
            "year": "Desember",
            "text": "Bulan kelahiran kita berdua.",
            "media": [
                "/images/1.jpeg",
                "/images/2.jpeg",
                "/images/3.jpeg",
                "/images/4.jpeg",
                "/images/5.jpeg",
                "/images/6.jpeg",
                "/images/7.jpeg",
                "/images/8.jpeg",
                "/images/9.jpeg",
            ]
        },
        {
            "year": "November",
            "text": "Liburan Ke Luar Negeri.",
            "media": [
                "/images/10.jpeg",
                "/images/12.jpeg",
                "/images/13.jpeg",
                "/images/14.jpeg",
            ]
        },
        {
            "year": "Other",
            "text": "Ngedate kita.",
            "media": [
                "/images/15.jpeg",
                "/images/16.jpeg",
                "/images/17.jpeg",
                "/images/18.jpeg",
                "/images/19.jpeg",
                "/images/20.jpeg",
            ]
        },
        {
            "year": "Photoboth",
            "text": "Tertawa dan bertahan bersama.",
            "media": [
                "/videos/1.mp4",
                "/videos/2.mp4"
            ]
        }
    ]

    return render_template("story.html", timeline=timeline)

if __name__ == "__main__":
    app.run()
