<?php


class Halaman extends CI_Controller {
			public function __construct(){
					parent::__construct();
					$this->load->helper('form');
					$this->load->library('form_validation');
					$this->load->library('upload');
					$this->load->helper('url_helper');
					$this->load->helper('text');
					$this->load->helper('date');
					$this->load->library('pagination');
			}
	public function view()
	{

		$this->load->view('pages/static/header1');
		$this->load->view('pages/forms/home');
		$this->load->view('pages/static/footer');

	}
	public function homes()
	{

		$this->load->view('pages/static/header');
		$this->load->view('pages/forms/homes');
		$this->load->view('pages/static/footer');

	}


	public function daftar()
	{
		if ($_POST) {
			$data = $this->input->post();
			$data['role'] = 'user';

			$this->db->insert('tb_admin',$data);

			redirect('admin/login');
		} else {
			$this->load->view('pages/static/header1');
			$this->load->view('pages/forms/daftar');
			$this->load->view('pages/static/footer');
		}
	}


	public function orders()
{
    if ($_POST) {
        // Konfigurasi untuk upload file
		$path = FCPATH . 'assets/file/';

		if (!is_dir($path)) {
			mkdir($path, 0755, true);
		}
        $config['upload_path']   = $path; // Menggunakan path absolut
        $config['allowed_types'] = '*';
        $config['max_size']      = 10048;
        
        // Load library upload
        $this->upload->initialize($config);

		// echo $config['upload_path'];
        // Tangani file upload
        if ($this->upload->do_upload('file')) {
            $uploadData = $this->upload->data();
            $file_name = $uploadData['file_name'];

            // Menyimpan data dari form ke array $data
            $data = $this->input->post();
            $data['username'] = $_SESSION['username'];
            $data['file'] = $file_name;

            // Insert data ke database
            $this->db->insert('orders', $data);

            redirect('home');
        } else {
            // Jika terjadi kesalahan saat upload
            $error = $this->upload->display_errors();
            echo $error;
        }
    } else {
        // Menampilkan form
        $data['orders'] = $this->db->order_by('created_at', 'DESC')->get('orders')->result();
        $data['kategori'] = $this->db->get('kategori')->result();

        $this->load->view('pages/static/header1');
        $this->load->view('pages/forms/orders', $data);
        $this->load->view('pages/static/footer');
    }
}



	public function kb()
	{
		if ($_POST) {
			$data = $this->input->post();
			$get = $this->db->where('jadwal_id',$data['jadwal_id'])->get('peserta')->row();
			
			if ($get) {
				$data['no_antri'] = $get->no_antri + 1;
			} else {
				$data['no_antri'] = '1';
			}
			
			$data['username'] = $_SESSION['username'];

			$this->db->insert('peserta',$data);

			redirect('home');
		} else {
			$data['jadwal'] = $this->db->order_by('tgl','DESC')->get_where('jadwal',['jenis'=>'KB'])->result();

			$this->load->view('pages/static/header1');
			$this->load->view('pages/forms/kb',$data);
			$this->load->view('pages/static/footer');
		}
	}

}
